implementation module controlaccess


import	StdBool, StdFunc, StdInt, StdList, StdMisc, StdTuple
import	commondef, id, controldefaccess, controllayout, wstateaccess


eqfst3id :: !Id !(!Id,.x,.y) -> Bool
eqfst3id id1 (id2,_,_)	= id1==id2

getOSDefaultWindowMetrics :: OSWindowMetrics
getOSDefaultWindowMetrics = fst (OSDefaultWindowMetrics OSNewToolbox)


/*	Higher order access on [WElementHandle`].	*/

mapWElementHandles` :: (WItemHandle`->[.x]) ![WElementHandle`] -> [.x]
mapWElementHandles` f itemHs
	| isEmpty itemHs
	= []
	# (itemH,itemHs)	= HdTl itemHs
	= mapWElementHandle` f itemH ++ mapWElementHandles` f itemHs
where
	mapWElementHandle` :: (WItemHandle`->[.x]) !WElementHandle` -> [.x]
	mapWElementHandle` f (WRecursiveHandle`	itemHs _)
		= mapWElementHandles` f itemHs
	mapWElementHandle` f (WItemHandle` itemH)
		= f itemH

seekmapWElementHandle` :: (WItemHandle`->(Bool,x)) x ![WElementHandle`] -> (!Bool,x)
seekmapWElementHandle` f x itemHs
	| isEmpty itemHs
	= (False,x)
	# (itemH,itemHs)	= HdTl itemHs
	  (found,x)			= seekmapWItemHandle` f x itemH
	| found
	= (found,x)
	= seekmapWElementHandle` f x itemHs
where
	seekmapWItemHandle` :: (WItemHandle`->(Bool,x)) x !WElementHandle` -> (!Bool,x)
	seekmapWItemHandle` f x (WRecursiveHandle`	itemHs _)
		= seekmapWElementHandle` f x itemHs
	seekmapWItemHandle` f x (WItemHandle`		itemH)
		# (found,x)	= f itemH
		| found
		= (found,x)
		= (found,x)

statemapWElementHandles` :: !(Cond x) (WItemHandle` x -> x) !x ![WElementHandle`] -> x
statemapWElementHandles` cond f s itemHs
	| cond s
	= s
	| isEmpty itemHs
	= s
	# (itemH,itemHs)= HdTl itemHs
	# s				= statemapWElementHandle`  cond f s itemH
	# s				= statemapWElementHandles` cond f s itemHs
	= s
where
	statemapWElementHandle` :: (Cond x) (WItemHandle` x -> x) x !WElementHandle` -> x
	statemapWElementHandle` cond f s (WRecursiveHandle`	itemHs _)
		= statemapWElementHandles` cond f s itemHs
	statemapWElementHandle` cond f s (WItemHandle` itemH)
		= f itemH s


/*	Access operations on WElementHandle`.	*/

getcontrolstypes :: ![WElementHandle`] -> [(ControlType,Maybe Id)]
getcontrolstypes itemHs
	= mapWElementHandles` gettype itemHs
where
	gettype :: !WItemHandle` -> [(ControlType,Maybe Id)]
	gettype {wItemId`,wItemKind`}
		= [(getcontroltype wItemKind`,wItemId`)]
	where
		getcontroltype :: !ControlKind -> ControlType
		getcontroltype IsRadioControl			= "RadioControl"
		getcontroltype IsCheckControl			= "CheckControl"
		getcontroltype IsPopUpControl			= "PopUpControl"
		getcontroltype IsSliderControl			= "SliderControl"
		getcontroltype IsTextControl			= "TextControl"
		getcontroltype IsEditControl			= "EditControl"
		getcontroltype IsButtonControl			= "ButtonControl"
		getcontroltype IsCustomButtonControl	= "CustomButtonControl"
		getcontroltype IsCustomControl			= "CustomControl"
		getcontroltype IsCompoundControl		= "CompoundControl"
		getcontroltype (IsOtherControl type)	= type

getcompoundstypes :: !Id ![WElementHandle`] -> [(ControlType,Maybe Id)]
getcompoundstypes id itemHs
	= snd (getcompoundstypes` id itemHs)
where
	getcompoundstypes` :: !Id ![WElementHandle`] -> (Bool,[(ControlType,Maybe Id)])
	getcompoundstypes` id itemHs
		= seekmapWElementHandle` (getcompoundtypes id) [] itemHs
	where
		getcompoundtypes :: !Id !WItemHandle` -> (!Bool,[(ControlType,Maybe Id)])
		getcompoundtypes id {wItemId`,wItemKind`,wItems`}
			| wItemKind`<>IsCompoundControl	= (False,[])
			| isNothing wItemId`			= getcompoundstypes` id wItems`
			| id<>fromJust wItemId`			= getcompoundstypes` id wItems`
											= (True,getcontrolstypes wItems`)

getcontrolslayouts :: ![WElementHandle`] !(![Id],![(Id,Bool,(Maybe ItemPos,ItemOffset))])
									   -> (![Id],![(Id,Bool,(Maybe ItemPos,ItemOffset))])
getcontrolslayouts itemHs ids_layouts
	= statemapWElementHandles` (isEmpty o fst) getlayouts ids_layouts itemHs
where
	getlayouts :: !WItemHandle` !(![Id],![(Id,Bool,(Maybe ItemPos,ItemOffset))])
							  -> (![Id],![(Id,Bool,(Maybe ItemPos,ItemOffset))])
	getlayouts itemH=:{wItemId`,wItemAtts`,wItems`,wItemPos`} ids_layouts=:(ids,layouts)
		| isNothing wItemId`
		= getcontrolslayouts wItems` ids_layouts
		| not hadId
		= getcontrolslayouts wItems` ids_layouts
		= getcontrolslayouts wItems` (ids1,layouts1)
		with
			itemPos			= if hasAtt (Just (getControlPos` posAtt)) Nothing
			(hasAtt,posAtt)	= Select isControlPos` (ControlPos` (Left,zero)) wItemAtts`
			layout			= (itemId,True,(itemPos,{vx=wItemPos`.x,vy=wItemPos`.y}))
			(_,layouts1)	= Replace (eqfst3id itemId) layout layouts
	where
		itemId				= fromJust wItemId`
		(hadId,ids1)		= RemoveCheck itemId ids

getcontrolsviewsizes :: ![WElementHandle`] !(![Id],![(Id,Bool,Size)]) -> (![Id],![(Id,Bool,Size)])
getcontrolsviewsizes itemHs ids_sizes
	= statemapWElementHandles` (isEmpty o fst) getsizes ids_sizes itemHs
where
	getsizes :: !WItemHandle` !(![Id],![(Id,Bool,Size)]) -> (![Id],![(Id,Bool,Size)])
	getsizes itemH=:{wItemId`,wItemKind`,wItems`} ids_sizes=:(ids,sizes)
		| isNothing wItemId`
		= getcontrolsviewsizes wItems` ids_sizes
		| not hadId
		= getcontrolsviewsizes wItems` ids_sizes
		= getcontrolsviewsizes wItems` (ids1,sizes1)
		with
			info		= getWItemCompoundInfo` itemH.wItemInfo`
			hasHScroll	= isJust info.compoundHScroll
			hasVScroll	= isJust info.compoundVScroll
			itemSize	= itemH.wItemSize`
			size		= if (wItemKind`<>IsCompoundControl)
 							 itemSize
							 (RectSize (getCompoundContentRect getOSDefaultWindowMetrics hasVScroll hasHScroll (0,0, itemSize.w,itemSize.h)))
			(_,sizes1)	= Replace (eqfst3id itemId) (itemId,True,size) sizes
	where
		itemId			= fromJust wItemId`
		(hadId,ids1)	= RemoveCheck itemId ids

getcontrolsselects :: ![WElementHandle`] !(![Id],![(Id,Bool,SelectState)]) -> (![Id],![(Id,Bool,SelectState)])
getcontrolsselects itemHs ids_selects
	= statemapWElementHandles` (isEmpty o fst) getselects ids_selects itemHs
where
	getselects :: !WItemHandle` !(![Id],![(Id,Bool,SelectState)]) -> (![Id],![(Id,Bool,SelectState)])
	getselects itemH=:{wItemId`,wItemSelect`,wItems`} ids_selects=:(ids,selects)
		| isNothing wItemId`	= getcontrolsselects wItems` ids_selects
		| not hadId				= getcontrolsselects wItems` ids_selects
								= getcontrolsselects wItems` (ids1,selects1)
								with
									selectstate	= if wItemSelect` Able Unable
									select		= (itemId,True,selectstate)
									(_,selects1)= Replace (eqfst3id itemId) select selects
	where
		itemId					= fromJust wItemId`
		(hadId,ids1)			= RemoveCheck itemId ids

getcontrolsshowstates :: ![WElementHandle`] !(![Id],![(Id,Bool,Bool)]) -> (![Id],![(Id,Bool,Bool)])
getcontrolsshowstates itemHs ids_shows
	= statemapWElementHandles` (isEmpty o fst) getshowstates ids_shows itemHs
where
	getshowstates :: !WItemHandle` !(![Id],![(Id,Bool,Bool)]) -> (![Id],![(Id,Bool,Bool)])
	getshowstates itemH=:{wItemId`,wItemShow`,wItems`} ids_shows=:(ids,shows)
		| isNothing wItemId`	= getcontrolsshowstates wItems` ids_shows
		| not hadId				= getcontrolsshowstates wItems` ids_shows
								= getcontrolsshowstates wItems` (ids1,shows1)
								with
									show		= (itemId,True,wItemShow`)
									(_,shows1)	= Replace (eqfst3id itemId) show shows
	where
		itemId					= fromJust wItemId`
		(hadId,ids1)			= RemoveCheck itemId ids

getcontrolstexts :: ![WElementHandle`] !(![Id],![(Id,Bool,Maybe String)]) -> (![Id],![(Id,Bool,Maybe String)])
getcontrolstexts itemHs ids_texts
	= statemapWElementHandles` (isEmpty o fst) gettext ids_texts itemHs
where
	gettext :: !WItemHandle` !(![Id],![(Id,Bool,Maybe String)]) -> (![Id],![(Id,Bool,Maybe String)])
	gettext itemH=:{wItemId`,wItemKind`,wItems`,wItemInfo`} ids_texts=:(ids,texts)
		| isNothing wItemId`	= getcontrolstexts wItems` ids_texts
		| not hadId				= getcontrolstexts wItems` ids_texts
		| not hastext			= getcontrolstexts wItems` (ids1,texts )
								= getcontrolstexts wItems` (ids1,texts1)
								with
									(_,texts1)	= Replace (eqfst3id itemId) (itemId,True,Just textline) texts
	where
		itemId					= fromJust wItemId`
		(hadId,ids1)			= RemoveCheck itemId ids
		(hastext,textline)		= case wItemKind` of
									IsTextControl	-> (True,(getWItemTextInfo`   wItemInfo`).textInfoText)
									IsEditControl	-> (True,(getWItemEditInfo`   wItemInfo`).editInfoText)
									IsButtonControl	-> (True,(getWItemButtonInfo` wItemInfo`).buttonInfoText)
									_				-> (False,undef)

getcontrolsnrlines :: ![WElementHandle`] !(![Id],![(Id,Bool,Maybe Int)]) -> (![Id],![(Id,Bool,Maybe Int)])
getcontrolsnrlines itemHs ids_nrlines
	= statemapWElementHandles` (isEmpty o fst) getnrlines ids_nrlines itemHs
where
	getnrlines :: !WItemHandle` !(![Id],![(Id,Bool,Maybe Int)]) -> (![Id],![(Id,Bool,Maybe Int)])
	getnrlines itemH=:{wItemId`,wItemKind`,wItems`} ids_nrlines=:(ids,nrlines)
		| isNothing wItemId`		= getcontrolsnrlines wItems` ids_nrlines
		| not hadId					= getcontrolsnrlines wItems` ids_nrlines
		| wItemKind`<>IsEditControl	= getcontrolsnrlines wItems` (ids1,nrlines )
									= getcontrolsnrlines wItems` (ids1,nrlines1)
									with
										info		= getWItemEditInfo` itemH.wItemInfo`
										nrline		= (itemId,True,Just info.editInfoNrLines)
										(_,nrlines1)= Replace (eqfst3id itemId) nrline nrlines
	where
		itemId						= fromJust wItemId`
		(hadId,ids1)				= RemoveCheck itemId ids

getcontrolslooks :: ![WElementHandle`] !(![Id],![(Id,Bool,Maybe Look)]) -> (![Id],![(Id,Bool,Maybe Look)])
getcontrolslooks itemHs ids_looks
	= statemapWElementHandles` (isEmpty o fst) getlooks ids_looks itemHs
where
	getlooks :: !WItemHandle` !(![Id],![(Id,Bool,Maybe Look)]) -> (![Id],![(Id,Bool,Maybe Look)])
	getlooks itemH=:{wItemId`,wItemKind`,wItems`,wItemInfo`} ids_looks=:(ids,looks)
		| isNothing wItemId`= getcontrolslooks wItems` ids_looks
		| not hadId			= getcontrolslooks wItems` ids_looks
		| not haslook		= getcontrolslooks wItems` (ids1,looks )
							= getcontrolslooks wItems` (ids1,looks1)
							with
								(_,looks1)	= Replace (eqfst3id itemId) (itemId,True,look) looks
	where
		itemId				= fromJust wItemId`
		(hadId,ids1)		= RemoveCheck itemId ids
		(haslook,look)		= getlook wItemKind` wItemInfo`
		
		getlook :: !ControlKind !WItemInfo` -> (!Bool,Maybe Look)
		getlook IsCustomButtonControl info = (True,Just (getWItemCustomButtonInfo` info).cButtonInfoLook.lookFun)
		getlook IsCustomControl       info = (True,Just (getWItemCustomInfo`       info).customInfoLook.lookFun)
		getlook IsCompoundControl     info
			= (True,look)
		where
			compoundLookInfo= (getWItemCompoundInfo` info).compoundLookInfo
			look			= case compoundLookInfo of
								Just {compoundLook={lookFun}}	-> Just lookFun
								Nothing							-> Nothing
		getlook _ _
			= (False,undef)

getcontrolsminsizes :: ![WElementHandle`] !(![Id],![(Id,Bool,Maybe Size)]) -> (![Id],![(Id,Bool,Maybe Size)])
getcontrolsminsizes itemHs ids_sizes
	= statemapWElementHandles` (isEmpty o fst) getsizes ids_sizes itemHs
where
	getsizes :: !WItemHandle` !(![Id],![(Id,Bool,Maybe Size)]) -> (![Id],![(Id,Bool,Maybe Size)])
	getsizes itemH=:{wItemId`,wItemAtts`,wItems`} ids_sizes=:(ids,sizes)
		| isNothing wItemId`	= getcontrolsminsizes wItems` ids_sizes
		| not hadId				= getcontrolsminsizes wItems` ids_sizes
								= getcontrolsminsizes wItems` (ids1,sizes1)
								with
									(has_minsize,minatt)= Select isControlMinimumSize` (dummy "getcontrolsminsizes") wItemAtts`
									size				= (itemId,True,if has_minsize (Just (getControlMinimumSize` minatt)) Nothing)
									(_,sizes1)			= Replace (eqfst3id itemId) size sizes
	where
		itemId					= fromJust wItemId`
		(hadId,ids1)			= RemoveCheck itemId ids

getcontrolsresizes :: ![WElementHandle`] !(![Id],![(Id,Bool,Maybe ControlResizeFunction)])
									   -> (![Id],![(Id,Bool,Maybe ControlResizeFunction)])
getcontrolsresizes itemHs ids_resizes
	= statemapWElementHandles` (isEmpty o fst) getresizes ids_resizes itemHs
where
	getresizes :: !WItemHandle` !(![Id],![(Id,Bool,Maybe ControlResizeFunction)])
			  				  -> (![Id],![(Id,Bool,Maybe ControlResizeFunction)])
	getresizes itemH=:{wItemId`,wItemAtts`,wItems`} ids_resizes=:(ids,resizes)
		| isNothing wItemId`	= getcontrolsresizes wItems` ids_resizes
		| not hadId				= getcontrolsresizes wItems` ids_resizes
		| not hasResize			= getcontrolsresizes wItems` (ids1,resizes )
								= getcontrolsresizes wItems` (ids1,resizes1)
								with
									resize		= (itemId,True,Just (getControlResize` resizeAtt))
									(_,resizes1)= Replace (eqfst3id itemId) resize resizes1
	where
		itemId					= fromJust wItemId`
		(hadId,ids1)			= RemoveCheck itemId ids
		(hasResize,resizeAtt)	= Select isControlResize` (dummy "getresizes") wItemAtts`

getpopupitems :: ![WElementHandle`] !(![Id],![(Id,Bool,Maybe [String])]) -> (![Id],![(Id,Bool,Maybe [String])])
getpopupitems itemHs ids_titles
	= statemapWElementHandles` (isEmpty o fst) getpopuptitle ids_titles itemHs
where
	getpopuptitle :: !WItemHandle` !(![Id],![(Id,Bool,Maybe [String])]) -> (![Id],![(Id,Bool,Maybe [String])])
	getpopuptitle itemH=:{wItemId`,wItemKind`,wItems`,wItemInfo`} ids_titles=:(ids,titles)
		| isNothing wItemId`			= getpopupitems wItems` ids_titles
		| not hadId						= getpopupitems wItems` ids_titles
		| wItemKind`<>IsPopUpControl	= getpopupitems wItems` (ids1,titles )
										= getpopupitems wItems` (ids1,titles1)
										with
											info		= getWItemPopUpInfo` wItemInfo`
											title		= (itemId,True,Just info.popUpInfoItems`)
											(_,titles1)	= Replace (eqfst3id itemId) title titles
	where
		itemId			= fromJust wItemId`
		(hadId,ids1)	= RemoveCheck itemId ids

getselectedpopupitems :: ![WElementHandle`] !(![Id],![(Id,Bool,Maybe Index)]) -> (![Id],![(Id,Bool,Maybe Index)])
getselectedpopupitems itemHs ids_indices
	= statemapWElementHandles` (isEmpty o fst) getselectedpopup ids_indices itemHs
where
	getselectedpopup :: !WItemHandle` !(![Id],![(Id,Bool,Maybe Index)]) -> (![Id],![(Id,Bool,Maybe Index)])
	getselectedpopup itemH=:{wItemId`,wItemKind`,wItems`,wItemInfo`} ids_indices=:(ids,indices)
		| isNothing wItemId`			= getselectedpopupitems wItems` ids_indices
		| not hadId						= getselectedpopupitems wItems` ids_indices
		| wItemKind`<>IsPopUpControl	= getselectedpopupitems wItems` (ids1,indices )
										= getselectedpopupitems wItems` (ids1,indices1)
										with
											info		= getWItemPopUpInfo` wItemInfo`
											index		= (itemId,True,Just info.popUpInfoIndex`)
											(_,indices1)= Replace (eqfst3id itemId) index indices
	where
		itemId			= fromJust wItemId`
		(hadId,ids1)	= RemoveCheck itemId ids

getradioitems :: ![WElementHandle`] !(![Id],![(Id,Bool,Maybe [String])]) -> (![Id],![(Id,Bool,Maybe [String])])
getradioitems itemHs ids_titles
	= statemapWElementHandles` (isEmpty o fst) getradiotitle ids_titles itemHs
where
	getradiotitle :: !WItemHandle` !(![Id],![(Id,Bool,Maybe [String])]) -> (![Id],![(Id,Bool,Maybe [String])])
	getradiotitle itemH=:{wItemId`,wItemKind`,wItems`,wItemInfo`} ids_titles=:(ids,titles)
		| isNothing wItemId`			= getradioitems wItems` ids_titles
		| not hadId						= getradioitems wItems` ids_titles
		| wItemKind`<>IsRadioControl	= getradioitems wItems` (ids1,titles )
										= getradioitems wItems` (ids1,titles1)
										with
											info		= getWItemRadioInfo` wItemInfo`
											title		= (itemId,True,Just (map (\item->item.radioItem`) info.radioItems`))
											(_,titles1)	= Replace (eqfst3id itemId) title titles
	where
		itemId			= fromJust wItemId`
		(hadId,ids1)	= RemoveCheck itemId ids

getradiocontrolsmarks :: ![WElementHandle`] !(![Id],![(Id,Bool,Maybe Index)]) -> (![Id],![(Id,Bool,Maybe Index)])
getradiocontrolsmarks itemHs ids_marks
	= statemapWElementHandles` (isEmpty o fst) getmarks ids_marks itemHs
where
	getmarks :: !WItemHandle` !(![Id],![(Id,Bool,Maybe Index)]) -> (![Id],![(Id,Bool,Maybe Index)])
	getmarks itemH=:{wItemId`,wItemKind`,wItemInfo`,wItems`} ids_marks=:(ids,marks)
		| isNothing wItemId`			= getradiocontrolsmarks wItems` ids_marks
		| not hadId						= getradiocontrolsmarks wItems` ids_marks
		| wItemKind`<>IsRadioControl	= getradiocontrolsmarks wItems` (ids1,marks )
										= getradiocontrolsmarks wItems` (ids1,marks1)
										with
											info		= getWItemRadioInfo` wItemInfo`
											mark		= (itemId,True,Just info.radioIndex`)
											(_,marks1)	= Replace (eqfst3id itemId) mark marks
	where
		itemId			= fromJust wItemId`
		(hadId,ids1)	= RemoveCheck itemId ids

getcheckitems :: ![WElementHandle`] !(![Id],![(Id,Bool,Maybe [String])]) -> (![Id],![(Id,Bool,Maybe [String])])
getcheckitems itemHs ids_titles
	= statemapWElementHandles` (isEmpty o fst) getchecktitle ids_titles itemHs
where
	getchecktitle :: !WItemHandle` !(![Id],![(Id,Bool,Maybe [String])]) -> (![Id],![(Id,Bool,Maybe [String])])
	getchecktitle itemH=:{wItemId`,wItemKind`,wItems`,wItemInfo`} ids_titles=:(ids,titles)
		| isNothing wItemId`			= getcheckitems wItems` ids_titles
		| not hadId						= getcheckitems wItems` ids_titles
		| wItemKind`<>IsCheckControl	= getcheckitems wItems` (ids1,titles )
										= getcheckitems wItems` (ids1,titles1)
										with
											info		= getWItemCheckInfo` wItemInfo`
											title		= (itemId,True,Just (map (\item->fst item.checkItem`) info.checkItems`))
											(_,titles1)	= Replace (eqfst3id itemId) title titles
	where
		itemId			= fromJust wItemId`
		(hadId,ids1)	= RemoveCheck itemId ids

getcheckcontrolsmarks :: ![WElementHandle`] !(![Id],![(Id,Bool,Maybe [Index])]) -> (![Id],![(Id,Bool,Maybe [Index])])
getcheckcontrolsmarks itemHs ids_marks
	= statemapWElementHandles` (isEmpty o fst) getmarks ids_marks itemHs
where
	getmarks :: !WItemHandle` !(![Id],![(Id,Bool,Maybe [Index])]) -> (![Id],![(Id,Bool,Maybe [Index])])
	getmarks itemH=:{wItemId`,wItemKind`,wItemInfo`,wItems`} ids_marks=:(ids,marks)
		| isNothing wItemId`			= getcheckcontrolsmarks wItems` ids_marks
		| not hadId						= getcheckcontrolsmarks wItems` ids_marks
		| wItemKind`<>IsCheckControl	= getcheckcontrolsmarks wItems` (ids1,marks )
										= getcheckcontrolsmarks wItems` (ids1,marks1)
										with
											info		= getWItemCheckInfo` wItemInfo`
											indices		= getMarkIndices 1 info.checkItems`
											mark		= (itemId,True,Just indices)
											(_,marks1)	= Replace (eqfst3id itemId) mark marks
											
											getMarkIndices :: !Index ![CheckItemInfo`] -> [Index]
											getMarkIndices index [{checkItem`=(_,mark)}:items]
												# indexs	= getMarkIndices (index+1) items
												| marked mark
												= [index:indexs]
												= indexs
											getMarkIndices _ _
												= []
	where
		itemId			= fromJust wItemId`
		(hadId,ids1)	= RemoveCheck itemId ids

getslidersdirections :: ![WElementHandle`] !(![Id],![(Id,Bool,Maybe Direction)]) -> (![Id],![(Id,Bool,Maybe Direction)])
getslidersdirections itemHs ids_sliders
	= statemapWElementHandles` (isEmpty o fst) getdirections ids_sliders itemHs
where
	getdirections :: !WItemHandle` !(![Id],![(Id,Bool,Maybe Direction)]) -> (![Id],![(Id,Bool,Maybe Direction)])
	getdirections itemH=:{wItemId`,wItemKind`,wItemInfo`,wItems`} ids_sliders=:(ids,sliders)
		| isNothing wItemId`			= getslidersdirections wItems` ids_sliders
		| not hadId						= getslidersdirections wItems` ids_sliders
		| wItemKind`<>IsSliderControl	= getslidersdirections wItems` (ids1,sliders )
										= getslidersdirections wItems` (ids1,sliders1)
										with
											info		= getWItemSliderInfo` wItemInfo`
											slider		= (itemId,True,Just info.sliderInfoDir`)
											(_,sliders1)= Replace (eqfst3id itemId) slider sliders
	where
		itemId			= fromJust wItemId`
		(hadId,ids1)	= RemoveCheck itemId ids

getslidersstates :: ![WElementHandle`] !(![Id],![(Id,Bool,Maybe SliderState)]) -> (![Id],![(Id,Bool,Maybe SliderState)])
getslidersstates itemHs ids_states
	= statemapWElementHandles` (isEmpty o fst) getstates ids_states itemHs
where
	getstates :: !WItemHandle` !(![Id],![(Id,Bool,Maybe SliderState)]) -> (![Id],![(Id,Bool,Maybe SliderState)])
	getstates itemH=:{wItemId`,wItemKind`,wItemInfo`,wItems`} ids_states=:(ids,states)
		| isNothing wItemId`			= getslidersstates wItems` ids_states
		| not hadId						= getslidersstates wItems` ids_states
		| wItemKind`<>IsSliderControl	= getslidersstates wItems` (ids1,states )
										= getslidersstates wItems` (ids1,states1)
										with
											info		= getWItemSliderInfo` wItemInfo`
											state		= (itemId,True,Just info.sliderInfoState`)
											(_,states1)	= Replace (eqfst3id itemId) state states
	where
		itemId			= fromJust wItemId`
		(hadId,ids1)	= RemoveCheck itemId ids

getcontrolsframes :: ![WElementHandle`] !(![Id],![(Id,Bool,Maybe ViewFrame)]) -> (![Id],![(Id,Bool,Maybe ViewFrame)])
getcontrolsframes itemHs ids_frames
	= statemapWElementHandles` (isEmpty o fst) getframes ids_frames itemHs
where
	getframes :: !WItemHandle` !(![Id],![(Id,Bool,Maybe ViewFrame)]) -> (![Id],![(Id,Bool,Maybe ViewFrame)])
	getframes itemH=:{wItemId`,wItemKind`,wItemSize`,wItemInfo`,wItems`} ids_frames=:(ids,frames)
		| isNothing wItemId`			= getcontrolsframes wItems` ids_frames
		| not hadId						= getcontrolsframes wItems` ids_frames
		| wItemKind`<>IsCompoundControl	= getcontrolsframes wItems` (ids1,frames )
										= getcontrolsframes wItems` (ids1,frames1)
										with
											info		= getWItemCompoundInfo` wItemInfo`
											hasHScroll	= isJust info.compoundHScroll
											hasVScroll	= isJust info.compoundVScroll
											origin		= info.compoundOrigin
											itemRect	= getCompoundContentRect getOSDefaultWindowMetrics hasHScroll hasVScroll (PosSizeToRect origin wItemSize`)
											frame		= (itemId,True,Just (RectToRectangle itemRect))
											(_,frames1)	= Replace (eqfst3id itemId) frame frames
	where
		itemId			= fromJust wItemId`
		(hadId,ids1)	= RemoveCheck itemId ids

getcontrolsdomains :: ![WElementHandle`] !(![Id],![(Id,Bool,Maybe ViewDomain)]) -> (![Id],![(Id,Bool,Maybe ViewDomain)])
getcontrolsdomains itemHs ids_domains
	= statemapWElementHandles` (isEmpty o fst) getdomains ids_domains itemHs
where
	getdomains :: !WItemHandle` !(![Id],![(Id,Bool,Maybe ViewDomain)]) -> (![Id],![(Id,Bool,Maybe ViewDomain)])
	getdomains itemH=:{wItemId`,wItemKind`,wItemInfo`,wItems`} ids_domains=:(ids,domains)
		| isNothing wItemId`			= getcontrolsdomains wItems` ids_domains
		| not hadId						= getcontrolsdomains wItems` ids_domains
		| wItemKind`<>IsCompoundControl	= getcontrolsdomains wItems` (ids1,domains )
										= getcontrolsdomains wItems` (ids1,domains1)
										with
											info		= getWItemCompoundInfo` wItemInfo`
											domain		= (itemId,True,Just info.compoundDomain)
											(_,domains1)= Replace (eqfst3id itemId) domain domains
	where
		itemId			= fromJust wItemId`
		(hadId,ids1)	= RemoveCheck itemId ids

getcontrolsspaces :: (Int,Int) ![WElementHandle`] !(![Id],![(Id,Bool,Maybe (Int,Int))]) -> (![Id],![(Id,Bool,Maybe (Int,Int))])
getcontrolsspaces initspaces itemHs ids_spaces
	= statemapWElementHandles` (isEmpty o fst) (getspaces initspaces) ids_spaces itemHs
where
	getspaces :: (Int,Int) !WItemHandle` !(![Id],![(Id,Bool,Maybe (Int,Int))]) -> (![Id],![(Id,Bool,Maybe (Int,Int))])
	getspaces curspaces itemH=:{wItemId`,wItemKind`,wItemAtts`} ids_spaces=:(ids,spaces)
		| wItemKind`<>IsCompoundControl	= (ids,spaces)
		| isNothing wItemId`			= getcontrolsspaces newspaces itemH.wItems` ids_spaces
		| not hadId						= getcontrolsspaces newspaces itemH.wItems` (ids1,spaces )
										= getcontrolsspaces newspaces itemH.wItems` (ids1,spaces1)
										with
											space		= (itemId,True,Just newspaces)
											(_,spaces1)	= Replace (eqfst3id itemId) space spaces
	where
		itemId			= fromJust wItemId`
		(hadId,ids1)	= RemoveCheck itemId ids
		newspaces		= getControlItemSpace` (snd (Select isControlItemSpace` (ControlItemSpace` (fst curspaces) (snd curspaces)) wItemAtts`))

getcontrolsmargins :: ((Int,Int),(Int,Int)) ![WElementHandle`] !(![Id],![(Id,Bool,Maybe ((Int,Int),(Int,Int)))])
															 -> (![Id],![(Id,Bool,Maybe ((Int,Int),(Int,Int)))])
getcontrolsmargins initmargins itemHs ids_margins
	= statemapWElementHandles` (isEmpty o fst) (getmargins initmargins) ids_margins itemHs
where
	getmargins :: ((Int,Int),(Int,Int)) !WItemHandle` !(![Id],![(Id,Bool,Maybe ((Int,Int),(Int,Int)))])
													-> (![Id],![(Id,Bool,Maybe ((Int,Int),(Int,Int)))])
	getmargins curmargins itemH=:{wItemId`,wItemKind`,wItemAtts`} ids_margins=:(ids,margins)
		| wItemKind`<>IsCompoundControl	= (ids,margins)
		| isNothing wItemId`			= getcontrolsmargins newmargins itemH.wItems` ids_margins
		| not hadId						= getcontrolsmargins newmargins itemH.wItems` (ids1,margins )
										= getcontrolsmargins newmargins itemH.wItems` (ids1,margins1)
										with
											margin		= (itemId,True,Just newmargins)
											(_,margins1)= Replace (eqfst3id itemId) margin margins
	where
		itemId			= fromJust wItemId`
		(hadId,ids1)	= RemoveCheck itemId ids
		(left,right)	= fst curmargins
		(top,bottom)	= snd curmargins
		newHMargins		= getControlHMargin` (snd (Select isControlHMargin` (ControlHMargin` left right) wItemAtts`))
		newVMargins		= getControlVMargin` (snd (Select isControlVMargin` (ControlVMargin` top bottom) wItemAtts`))
		newmargins		= (newHMargins,newVMargins)
